/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.IncomingServiceRequest;
import com.ibm.hwmca.fw.bridge.request.Signature;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ReqInstantiateObject
extends IncomingServiceRequest {
    private static final String TRACE_MASKT = "XNBRJCOT";
    String className;
    String signature;
    Object[] arguments;
    Signature methodSignature;

    public boolean isRequestQuick() {
        return false;
    }

    public void readRequest() throws IOException {
        this.className = this.in.readUTF();
        this.signature = this.in.readUTF();
        this.methodSignature = new Signature(this.signature, this.bridge);
        this.arguments = this.methodSignature.readArguments(this.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRequest() throws IOException {
        Object result;
        Constructor<?> constructor;
        Class<?> targetClass;
        try {
            targetClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            this.sendError(7, "Class \"" + this.className);
            return;
        }
        try {
            constructor = targetClass.getDeclaredConstructor(this.methodSignature.getParameterClasses());
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            this.sendError(3, "Constructor with signature \"" + this.signature + "\" in class " + targetClass.getName());
            return;
        }
        try {
            Trace.trace(TRACE_MASKT, "Calling constructor with signature \"" + this.signature + "\" in class " + targetClass.getName());
            result = constructor.newInstance(this.arguments);
            Trace.trace(TRACE_MASKT, "Return from constructor with signature \"" + this.signature + "\" in class " + targetClass.getName());
        }
        catch (InstantiationException e) {
            this.sendError(5, "Class " + targetClass.getName() + " cannot be instantiated; it's abstract");
            return;
        }
        catch (ExceptionInInitializerError e) {
            this.sendError(5, "static initializer of class " + targetClass.getName());
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        catch (IllegalAccessException e) {
            this.sendError(4, "Constructor with signature \"" + this.signature + "\" in class " + targetClass.getName());
            return;
        }
        catch (InvocationTargetException e) {
            this.sendError(5, "Constructor with signature \"" + this.signature + "\" in class " + targetClass.getName() + " threw exception: " + e.getTargetException());
            Trace.trace(TRACE_MASKT, e.getTargetException());
            return;
        }
        Object object = this.getWriteLock();
        synchronized (object) {
            this.sendSuccess();
            this.out.writeUTF(this.getNameForObject(result));
            this.out.flush();
        }
    }
}

